## Fuel Wallet Terms Of Use Agreement

Last updated: October 16, 2024

## 1. The Fuel Wallet

The “**Fuel Wallet**” is a web3 software wallet application developed by **Fuel Labs Inc.**, a British Virgin Islands company (“Fuel” or “we”) for the purpose of managing private-public key pairs, blockchain addresses, and other data connected to user-controlled wallets. This agreement is between you and Fuel.  

The Fuel Wallet interacts with a single blockchain network: the “**Fuel Network**” (also known as Ignition), a layer-2 optimistic rollup.

## 2. Licence To Use

Provided that you abide by the terms of this agreement, Fuel grants to you a personal, non-revocable, non-transferrable, non-sublicensable, worldwide licence to use the Fuel Wallet. 

## 3. Eligibility To Use

You acknowledge that you meet the following requirements to use the Fuel Wallet:

1. age of majority in your jurisdiction; and,  
2. intend to use the Fuel Wallet for your own personal use and not for the benefit of a third-party; and,  
3. understand the nature of the Fuel Network, blockchain wallets, and blockchain transactions; and,  
4. intend to use the Fuel Wallet for development purposes only; and,  
5. capable of securing your digital device(s) that are for use with the Fuel Wallet; and,  
6. not accessing the Fuel Wallet from a territory that is the subject of comprehensive economic sanctions by the British Virgin Islands or the United Kingdom; and  
7. not subject to sanctions by the government of the British Virgin Islands, US Department of Treasury’s Office of Foreign Assets Control, the United Nations Security Council, or pursuant to European Union and/or United Kingdom Regulations.

If at any time you are no longer eligible to use the Fuel Wallet, according to the above criteria, then you must discontinue using the Fuel Wallet. 

## 4. App Store Additional Terms

You acknowledge that the Fuel Wallet is offered by Fuel and not by Apple, Google, or any app store developer. Fuel is solely responsible for providing support for the Apps, and for any product liability, infringement of third-party intellectual property rights, failure to conform to laws or regulatory requirements, or any other failure of the Fuel Wallet. Failure of the Fuel Wallet to conform to the warranties of this Agreement shall entitle you to a refund of any amount paid to an app store.  

The company (including any subsidiaries and affiliates) providing the app store from which You obtain the Fuel Wallet shall be considered a third-party beneficiary under this agreement, and shall be entitled to enforce the terms of this agreement.   

You agree to abide by the terms of any third-party agreements that govern your interactions with the Fuel Wallet and an app store.

## 5. Your Security: Backup Phrases

The Fuel Wallet makes use of an industry standard for “Backup Phrases” that permits you to import a seed that can be used to generate private-public key pairs in a deterministic manner. If you choose to import a Backup Phrase that you have used with other wallet software, it is possible that this Backup Phrase could be linked to digital assets that are not supported by the Fuel Wallet. Although the Fuel Wallet may be used with such Backup Phrases (and there is no way for Fuel to determine the type of Backup Phrase you use), we discourage this practice and encourage you to use a new Backup Phrase that is not associated with valuable blockchain assets. 

You are solely responsible for the retention and security of your Backup Phrases and your unique digital or hardware credentials (for example, iCloud and Google Passkeys, hardware authentication devices such as Yubikeys) that are tied to your smart contract wallets (“Passkeys”). Your Backup Phrases and/or Passkeys are the only way to access the cryptocurrency associated with your Account. Anyone that has access to your Backup Phrases and/or Passkeys can access your cryptocurrency.

IF YOU LOSE YOUR BACKUP PHRASE AND/OR PASSKEYS, YOU WILL NOT BE ABLE TO ACCESS YOUR CRYPTOCURRENCY IN THE FUEL WALLET. YOU ACKNOWLEDGE THAT FUEL DOES NOT STORE AND IS NOT RESPONSIBLE IN ANY WAY FOR THE SECURITY OF YOUR BACKUP PHRASE AND/OR PASSKEYS. YOU AGREE TO HOLD FUEL AND ITS AFFILIATES HARMLESS FOR ANY LOSSES ARISING FROM YOU LOSING YOUR BACKUP PHRASE AND/OR PASSKEYS. YOU AGREE THAT FUEL AND ITS AFFILIATES SHALL NOT BE LIABLE IN ANY WAY IF YOU LOSE YOUR BACKUP PHRASE AND/OR PASSKEYS AND CANNOT ACCESS YOUR ASSETS.

## 6. Non-custodial; ownership and control

The Fuel Wallet is non-custodial software, which means Fuel never takes control of your assets and by using it, you acknowledge that you are not transferring your assets to Fuel. You own and control digital assets held in your Fuel Wallet. As the sole owner of digital assets in your Fuel Wallet, you shall bear all risk of loss of such digital assets. Fuel shall have no liability for digital asset fluctuations or loss associated with your use of the Fuel Wallet. At any time, subject to outages, downtime, and other applicable policies, you may withdraw your digital assets by sending it to a different blockchain address.

## 7. Third Party Materials

The Fuel Wallet may incorporate or contain links to third-party services, DEXs, and/or Dapps which supply data about things, events, or prices (“Third Party Materials”). We provide access to Third Party Materials only as a convenience, do not have control over their content, and do not recommend, warrant or endorse, and are not responsible for the availability, legitimacy ore reliability of the content, products, services, or assets on or accessible from those Third Party Materials (including any related websites, resources or links displayed therein). You should always double-check any data that you receive through the Fuel Wallet using independent sources. Fuel is not responsible for any errors, whether due to display bugs or incorrect APIs (or any other cause) in relation to third-party data displayed within the Fuel Wallet (even if not labelled as being “third-party data”). You are solely responsible for any fees or costs associated with accessing Third Party Materials.

We make no warranties or representations, express or implied, about such linked Third Party Materials, the third parties they are owned and operated by, the information contained on them, the suitability of their products or services, or the assets they make accessible. You acknowledge sole responsibility for and assume all risk arising from your use of any Third Party Materials, third-party websites, applications, or resources. Third Party Materials may provide access to assets which have high risks of illiquidity, devaluation, lockup, or loss. Fuel and its affiliates shall not bear any liability whatsoever for any damage caused by any Third-Party Materials. You should use care in linking your Fuel Wallet with any Third-Party Materials or otherwise providing any third-parties with access to the Product.

## 8. API Disclaimer

The Fuel Wallet depends on backend services (APIs) that may not always function correctly or be available. Although Fuel takes care to ensure continuous operation of the Fuel Wallet, you should be aware that downtime may occur and features may be updated which may cause technical issues. Fuel is not responsible for any delays, errors, or problems that you may encounter due to service unavailability. 

## 9. No Warranty

To the maximum extent permitted by law, the Fuel Wallet is provided on an “as-is”, “as-available” basis.	  

The Fuel Wallet is provided to you without any warranty of any kind, to the maximum extent permitted by law. The foregoing warranty disclaimer is applicable without regard to the type of warranty, whether fitness for a specific purpose, merchantability, or any other warranties imposed by law (whether common law, statute, or any other source of law). 

## 10. Limitation Of Liability

Notwithstanding any term of this agreement, Fuel’s maximum liability to you shall be limited to the greater of: a) the amount paid to Fuel for the Fuel Wallet multiplied by fifty; or b) $100. The foregoing limitation of liability shall apply in aggregate, for all claims, no matter the cause or nature of your claim.   

In no case shall Fuel be liable to you for special, incidental, punitive, or consequential damages. Furthermore, you acknowledge that Fuel is not responsible for any loss of digital assets (valuable or otherwise) that you may experience due to use or misuse of the Fuel Wallet.   

You acknowledge that the limitation of liability in this clause is an integral part of this agreement and that Fuel could not offer the Fuel Wallet to you without your assent to the terms of this clause. 

## 11. Indemnification

You shall indemnify Fuel and its contractors, officers, directors, affiliates, and service providers against any claims brought by you (or by a third party in relation to your use of the Fuel Wallet) for which the loss claimed for is partly or entirely caused by your misuse of the Fuel Wallet or breach of this agreement. 

## 12. Feedback

You may use the Fuel Wallet without providing any feedback to Fuel. If you provide any feedback in relation to the Fuel Wallet then you acknowledge that Fuel may implement your idea, concept, or suggestion without any amounts being due to you. 

## 13. Telemetry

The Fuel Wallet makes use of industry-standard telemetry, which Fuel uses to improve the product and ensure a quality experience for users. Fuel telemetry does not include personally identifying information about you or other users. Fuel telemetry is collected, processed, and used according to the Fuel Wallet Privacy Policy. 

## 14. Amendment

You may not amend this agreement. Fuel may amend this agreement by providing you with at least five business days’ notice. If you disagree with any proposed amendment to this agreement then your sole remedy shall be to cease using the Fuel Wallet. 

## 15. Assignment

You may not assign this agreement. Fuel may assign this agreement as part of the sale of all or substantially all of its business, or as part of a corporate restructuring. 

## 16. Legal Notice

You may provide notice to Fuel by writing to: [legal@fuel.sh](mailto:legal@fuel.sh). 

## 17. Choice Of Forum

Any disputes related to this agreement shall be heard in the International Arbitration Centre of the British Virgin Islands. You may not bring a claim in any other forum and agree to promptly discontinue any actions pursued in any other forum. 

## 18. Governing Law

This agreement, and any disputes related to it, shall be governed by the laws of the British Virgin Islands. 

## 19. Entire Agreement

This is the entire agreement between the parties and it supersedes any other understandings, agreements, or representations. Each party mutually acknowledges that they have entered into this agreement without relying on any document, representation, or information that is not expressly provided for in this agreement.

## 20. Severability

Any provision or clause of this agreement, if void, invalid, unlawful, or unenforceable, shall be read down, or if it is not possible to do so while respecting the intention of the parties, severed from this agreement (to the minimum extent necessary).   

# Fuel Wallet Privacy Policy

## 1. Who We Are

The right to privacy is a fundamental human right. We, Fuel Labs Inc., make products that respect your rights in the way that they operate and empower you to ensure that your privacy is respected by others.

## 2. How The Fuel Wallet Works

The “Fuel Wallet” is downloadable software that was developed in a manner that enables you, the user of it, to make use of the Fuel blockchain network in a way that does not require you to disclose personal information (such as your name, an email address, or other identifiers that are commonly required for software products). Instead, the Fuel Wallet relies on a mathematical system for generating private-public key pairs (with corresponding “addresses”) derived from a “Seed Phrase” that is known only to you.   

When you first use the Fuel Wallet a Seed Phrase will be generated by the application or you may supply a new one. If you use a pre-existing Seed Phrase then you may be disclosing information to anyone else who has a copy of that Seed Phrase, so for maximum privacy it is recommended that you generate a new Seed Phrase. You may also generate a new Seed Phrase using standard tools provided by other wallet providers or software libraries, and then make use of that Seed Phrase in the Fuel Wallet. This works because the Fuel Wallet uses standard methods for generating addresses, methods that are used by most other types of blockchain wallets.   

We encourage you to read this privacy policy in conjunction with advice found elsewhere regarding how to use blockchain networks in a safe, secure, and private manner. 

## 3. What We Collect And Store

The Fuel Wallet connects to backend server(s) that connect to the Fuel blockchain network. You may make use of a backend server that you supply or Fuel may choose to provide a backend server for you to use. If you make use of a backend server that Fuel operates then this privacy policy applies to that use of the backend server too (the “Fuel Backend”).   

We collect certain incidental data as part of your use of the Fuel Backend (if you use it), but we do not collect personal data such as IP addresses and other device identifiers. We do not perform analytics or use any third-party analytics providers. The foregoing information is collected as part of providing the backend software service that permits the Fuel Wallet to fetch and transmit information to the Fuel blockchain network and is a necessary part of the interaction between client and server. This information is supplied by your device as part of the standard use of HTTPS requests from the Fuel Wallet to the backend servers that then connect to the Fuel blockchain network (“Backend API Calls”). 

In addition to incidental data that is collected in relation to Backend API Calls, the Fuel Wallet may also store and transmit certain telemetry data, crash/bug data, and other logs that we collect (“Telemetry Data”) in order to help ensure the quality of the Fuel Wallet. Telemetry Data does not include personal information and does not include your private key(s), public key(s), Seed Phrase(s), or similar data. 

## 4. Maximising Your Privacy

Blockchain networks are designed to be used in a decentralised manner and the Fuel Wallet can be configured to maximise this aspect if you so choose. Better privacy is obtained by making use of your own backend server that you control (instead of the Fuel Backend, see above). We encourage you to run your own backend server and use it for your transactions, in order to better protect your privacy, ensure continuity of service, and to more properly make use of decentralised software.   

Although we do not store your name, address, email address, phone number, or other personal identifiers that would relate your personal identity to your use of the Fuel Wallet, it is possible that your patterns of use of the Fuel Wallet, such as making transactions involving addresses known by others to be associated with you, could reveal information about your use of the Fuel blockchain network.   

We encourage users to be mindful of their use, and state of the art precautions surrounding identity that may help to ensure your privacy. 

## 5. Optional User Support Service

We may offer technical support to users like you. Making use of the user support that may be offered is not required in order to make use of the Fuel Wallet.   

If we offer it and you make use of our support services then you should be mindful that this may provide us with your email address or other contact information that could be related to your use of the Fuel Wallet. Even if we do not offer technical support, it’s possible that you could reach out to us by other channels, in which case this policy applies to that communication.   

Our user support systems, to the extent that they are offered, maintain records in order to provide us with a written record regarding issues, which may be retained for liability purposes, training purposes, or to ensure continuity of support. 

## 6. Collection Purposes

In addition to what is described elsewhere in this policy, we collect personal and other information for the following purposes:

1. improving the Fuel Wallet; or,  
2. providing the Fuel Wallet and Backend API Calls to you; or,  
3. understanding how users make use of the Fuel Wallet in order to improve the offering; or,  
4. providing technical support services; or,  
5. ensuring that we only respond to data access requests from the person to whom the data access request relates; or,  
6. debugging and solving other technical issues with the Fuel Wallet product.

## 7. Personal Data And Sensitive Personal Data

We do not collect any “personal data” or “sensitive personal data”, as defined in applicable legislation in the British Virgin Islands. 

We strongly discourage users from sending sensitive personal data to us by way of email, user support ticket, mail, or other means. 

## 8. How We Handle Personal Data

We may, in some circumstances, collect personal data that relates to you or could be related to you in the future. Personal data, including data that could become personal data if correlated with other information held by us or others, is protected by security measures such as encryption, permissions, and “need to know” access. 

All personnel (whether employees or contractors) who have access to personal data are contractually obligated to protect it. 

## 9. Blockchain Networks

The Fuel Wallet enables you to create blockchain transactions on the Fuel blockchain network. Blockchain transactions are generally permanent and immutable. We do not control, and cannot alter, the Fuel blockchain network. You should take care to only create transactions that you wish to be public and permanent. 

## 10. Data Retention

Data that we collected is retained until the data is no longer useful for the purpose(s) for which the data was collected. Some data may be of a transient nature, such as automatically generated logs for cloud services, and may be deleted shortly after being generated, whereas other data may be retained for years. In each case, we consider the type of data, collected purpose, and current need. 

## 11. Our Website(s)

You may obtain information, or even download software, in relation to Fuel from websites that may include websites run by other legal entities (i.e. affiliates), including our social media channels (together, “Fuel Websites”). The Fuel Websites may make use of cookies or other persistent identifiers, and may make use of analytics software in order to profile users to understand what information people are seeking and how best to serve you and other users. You may need to check the privacy policies applicable to these Fuel Websites in order to understand the impact on your privacy. You may minimize the disclosure of information in relation to the Fuel Websites by only downloading the Fuel Wallet from an official app store, which is run by an independent company (i.e. Apple or Google).

## 12. Government Requests

We abide by the law, while balancing our legal obligation with the right to privacy that users have. We may provide information to law enforcement or other government authorities in the British Virgin Islands (or elsewhere) upon receiving a production order or other lawful request for data. 

## 13. Data Access Request

You may write to us in order to obtain access to the personal data that we collect and store that relates to you: [legal@fuel.sh](mailto:legal@fuel.sh). 

## 14. Right To Correct Records

If you believe that information (of any kind) held by us may be inaccurate or incomplete then you may write to us in order to correct the data: [legal@fuel.sh](mailto:legal@fuel.sh).

## 15. Information Commissioner And Your Rights

We are based in the British Virgin Islands, and the laws of the British Virgin Islands apply to our operations. 

You may write to the Information Commissioner of the British Virgin Islands if you have a complaint regarding our handling or processing of data. We encourage you to write to us first, in order to resolve any issues: [legal@fuel.sh](mailto:legal@fuel.sh). 

## 

